﻿using System;
using System.Collections.Generic;
using System.Xml.Linq;

namespace Programming_CSharp
{
    // Prosta klasa klienta
    public class Customer
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string EmailAddress { get; set; }
    }

    // Główny program
    public class Tester
    {
        static void Main()
        {
            List<Customer> customers = CreateCustomerList();

            var customerXml = new XDocument();
            var rootElem = new XElement("Customers");
            customerXml.Add(rootElem);
            foreach (Customer customer in customers)
            {
                // Tworzenie nowego elementu reprezentującego obiekt klienta
                var customerElem = new XElement("Customer");

                // Dodawanie elementu reprezentującego właściwość FirstName do elementu klienta
                var firstNameElem = new XElement("FirstName", customer.FirstName);
                customerElem.Add(firstNameElem);

                // Dodawanie elementu reprezentującego właściwość LastName do elementu klienta
                var lastNameElem = new XElement("LastName", customer.LastName);
                customerElem.Add(lastNameElem);

                // Dodawanie elementu reprezentującego właściwość EmailAddress do elementu klienta
                var emailAddress = new XElement("EmailAddress", customer.EmailAddress);
                customerElem.Add(emailAddress);

                // Wreszcie dodanie elementu klienta do dokumentu XML
                rootElem.Add(customerElem);
            }

            Console.WriteLine(customerXml.ToString());
            Console.Read();
        }

        // Tworzenie listy klientów z przykładowymi danymi
        private static List<Customer> CreateCustomerList()
        {
            List<Customer> customers = new List<Customer>
                {
                new Customer { FirstName = "Marian",
                               LastName = "Opania",
                               EmailAddress = "marian0@onet.pl"},
                new Customer { FirstName = "Kajetan",
                               LastName = "Hardy",
                               EmailAddress = "kajtek0@interia.pl"},
                new Customer { FirstName = "Dorota",
                               LastName = "Czapska",
                               EmailAddress = "dorota0@adresik.pl"},
                new Customer { FirstName = "Jadwiga",
                               LastName = "Gaterska",
                               EmailAddress = "jadzia@wp.pl"},
                new Customer { FirstName = "Lucyna",
                               LastName = "Harmata",
                               EmailAddress = "lucyna0@interia.pl"}
                };
            return customers;
        }
    }
}